 //This program was coded by Deniz YILMAZ 
 //Please contact dyilmaz@munzur.edu.tr for any questions
 //Before run the program, the user must prepare a file in format .txt
 // the units used are in mm and second 


 // Initialization
  
  clear
  mode(0);
  ieee(1);
  clearglobal;

 //            Declaration of function 
        
   function y = Inf3D_BI_O(x)   //Function I(t)_BEST-WR
        y1 = Ss(1)*x^0.5
        y2=-Ss(1)*%pi^0.5/(2*Ss(2)^0.5)*erf((Ss(2)*x)^0.5)
        y3=(A*(1-B)*Ss(1)^2+B*s_std)*x 
        y4=-(A*(1-B)*Ss(1)^2+B*s_std)*(1-exp(-Ss(2)*x))/Ss(2)   
        y=y1+y2+y3+y4      
   endfunction   
  
  
   function y = er_sol_BI(Ss,m)    // Objective Function for optimization
      y = Y_opt-Inf3D_BI_O(X_opt);  
   endfunction    
   

//              Read file
//please prepare a folder that contains all the beerkan file such as name_.txt
        pwd;
       
    
        T1 = uigetdir(ans,'Go to main directory that contains data files');
        
        if T1 == '' then
            chdir(T1);
            x_mdialog('program is ended','Press ok');
            abort;
        end
       
        
        chdir(T1);
        T2=T1;
        
        
        file_name_  = uigetfile(['*.txt'],T2,'Select data file');
        
        if file_name_ == '' then
            chdir(T1);
            x_mdialog('BEST program is ended','Caution: remove files from \Result and \Figures folders','Press ok');
            abort;
        end
        
        ll1 = length(T2);
        ll2 = length(file_name_);
        file_name = part(file_name_,(length(T2)+2):(length(file_name_)-4));

entry = read(file_name+'.txt',-1,3);           //--> data file

nbl = size(entry,1);                           // number of line of data file
    
    rd = entry(1,1);                         // ring radius [mm]
    Q0 = entry(2,1);                         // initial vol water content 
    Qs = entry(3,1);                         // saturated vol water content
      
     
    
    jj0 = 4;   //ligne start experimental data
    jj = jj0;
    jj = jj+1;
    c0 = jj;

    while (entry(jj,2)~=0);
        X2_(jj+1-c0,1) = entry(jj,2);
        Y2_(jj+1-c0,1) = entry(jj,3);
       jj = jj+1;
      end
   
    X2 = [0;X2_];
    Y2 = [0;Y2_]; 
 
    
// BEST method constants

    gammaa = 0.75;
    betaa = 0.6;
    thetar = 0;               

// coefficients A B C 

     A = gammaa/(rd*(Qs-Q0));
     B =((2-betaa)/3);
     C =  1/(2*(1-betaa))*log(1/betaa);     
     
     n_data=size(X2,1);
     E=0; //initial threshold      
     

// ******************step 1 : Program found the steady state beginning time *******************
//method Di Prime to detect the steady state  (equation 13)          
i=2;
cpt=n_data-2;
[ct1 ct2]=reglin(X2(n_data-i:n_data)',Y2(n_data-i:n_data)');
while E<0.02

            cpt=cpt-1;
            
            E=abs((Y2(cpt)-ct1*X2(cpt)-ct2)/Y2(cpt));

            
end    // we know that the steady state is reached
            
       i=n_data-cpt-2 ;  // nombre of points used for the regression of steady state
       [s_std i_std]=reglin(X2(n_data-i+1:n_data)',Y2(n_data-i+1:n_data)');
        t_f=X2(n_data-i+1);
        
        disp("Results for "+file_name)
        disp('  t_steadystate [s]    s_std [mm/s]]       i_std [mm]')
        disp([t_f s_std i_std])

// transient points for the optimization procedure
 
//optimisation procedure

X_opt=X2(1:n_data-i); Y_opt=Y2(1:n_data-i);


s0=[0.5 0.1];   //initial parameters S and alpha_WR  can change according to the unit used
[p2,v2] = lsqrsolve(s0,er_sol_BI,size(X_opt,1));
Ss=p2;S=Ss(1);alpha_WR=Ss(2);

Ks=s_std-A*S^2;

//Fit error 

Er_fit=(sum((Y_opt-Inf3D_BI_O(X_opt))^2)/sum(Y_opt^2))^0.5;

format("v",8)

disp(" S [mm/s^0.5]  Ks [mm/s]  alpha_WR [s^-1]   Fit Error ")
disp( [S Ks alpha_WR Er_fit])





//             PLOT   

clf(1)

   //graph transient 
title("Beerkan Point "+file_name,"fontsize", 4,"color", 'k')

plot(X2,Y2,'or')  //points analytiques Icum transient


plot(X_opt,Inf3D_BI_O,'--b')    // model BEST-WR
        p=gce();                                 
        p.parent.font_size=4;        //modification axes
        p.children.thickness=3;       //modification polypline
        p.children.line_style=9;
        
        
plot(X2(n_data-i:n_data),s_std*X2(n_data-i:n_data)+i_std,'k')
        p=gce();                                
        xlabel("$t\,[s]$","fontsize", 4)
        ylabel("$I_c_u_m\,[mm]$","fontsize", 4)
        p.parent.font_size=4;        //modification axes
        p.children.thickness=5 ;      //modification polypline
        //p.children.line_style=8;
        
        legend(["$Experimental$";"$BEST-WR$";"$Steady-steate$"],4);
        a=gce();
        a.font_size=4;        






