// functions for direct and inverse modelling PSD 

// PSD experimental data
   
     function y = FF_exp(D,Dd,FFd)
         z = interpol(D,Dd,FFd);
         y = min(max(0,z),1);
     endfunction  
   
// PSD analysis

// Inverse analysis of PSD

  function y =meandiam(Dd,FFd)
    FF_ = FFd-[0;FFd(1:(size(FFd,1)-1),1)];
    y = FF_'*Dd;
    endfunction
    
  function y=FF(x)
      y=(1+(a*x.^(-1)).^b).^(-(1-2/b)),
  endfunction
  
  function y=FF_V(x,p)
      a=p(1);
      b=p(2);
      y=(1+(a*x.^(-1)).^b).^(-(1-2/b)),
    endfunction

  function e=f1_FF(p,m)
      a=p(1);b=p(2),
      e=FF_-(1+(a*D_.^(-1)).^b).^(-(1-2/b));
  endfunction

  function y=sol_FF(Dd,FFd)
    D_ = Dd;
    FF_ = FFd;
    
    z=meandiam(Dd,FFd);
    p0 = [z 2.5];
    
    [p]=lsqrsolve(p0,f1_FF,size(Dd,1));
    
    y = [p(1) p(2)];
  endfunction  
    
// determination of fractal dimension

    function  er = fuentes1(s,m)
      er=e^(2*s)+(1-e)^s-1;
    endfunction

    function y = sfractal(e,s0)
      y=lsqrsolve(s0,fuentes1,1);
    endfunction


// determination of BEST via PSD analysis

    function y = n_function_PSD(N,s)
        M = 1-2/N;
        pM = (M*N)/(1+M);
        ck = (2*s-1)/(2*s*(1-s));
        pm = pM/(1+ck);
        m = (1/pm)*(((1+pm^2)^0.5)-1);
        y = 2/(1-m);      
    endfunction
    
// determination of sand and clay fractions

    function y = S_MM(x)
        y = 1/(1+exp(-x))
    endfunction
    
    function y = n_function_MM(ps,pc)
        x1 = 24.547 - 0.238*ps - 0.082*pc;
        x2 = -3.569 + 0.081*ps;
        x3 = 0.694 - 0.024*ps + 0.048*pc;
        y = 2.18 + 0.11*(48.087-44.954*S_MM(x1)-1.023*S_MM(x2)-3.896*S_MM(x3));        
    endfunction



