// Treatment data functions

  function y = qexp(t,x)                    // estimation of the derivative in regards to time of vector x with mean suare root time for the antecedant (qexpt)
      y = zeros(size(x,1)-1,2)
      for i = 1:(size(x,1)-1)                                        
      y(i,2) = (x(i+1)-x(i))/(t(i+1)-t(i));
      y(i,1) = (((t(i)^0.5)+(t(i+1))^0.5)/2)^2;           
      end;
    endfunction
  
  function y = qend(t,x,n)
      z = qexp(t,x);
      z2 = z(:,2);
      y = mean_end(z2,n);
   endfunction
  
   function y=q_inf(t,x,n)
      z = qend(t,x,n-1);
      z2 = ab_end(t,x,n);
      z3 = z2(2,1);
      y = min(z,z3);
    endfunction

// 1.c CL Infiltration inverse modeling
     
   function y = sol_CL(t,I,n1,n2,nc)
      t_exp = t(n1:nc:n2,:);
      I_exp = I(n1:nc:n2,:);
      x_CL = t_exp.^0.5;
      y_CL = I_exp./(t_exp.^0.5);
      [a,b,sig] = reglin(x_CL',y_CL');
      Ss = b;
      Kss = (a-A*b^2)/B;
      y=[Kss Ss];                               //[Rk Rs]
    endfunction


 // 1.c.1 BEST slope
  
    function y = Inf3D_BS_0(x)
        y = Ss*x.^0.5+(B*qexpinf+(1-B)*A*Ss^2)*x;
    endfunction
    
     function y = er_sol_BS(p2,m)
        Ss = p2(1);
        y = Icum-Inf3D_BS_0(tcum);  
      endfunction     
  

// 1.c.2 BEST intercept -BI- Infiltration inverse modeling   

   function y = Inf3D_BI_O(x)
        y = Ss*x.^0.5+B*C/b_end*Ss^2*x+A*Ss^2*x;            // attention C est ici défini différemment que dans l'article
   endfunction   
  
  
   function y = er_sol_BI(Ss,m)
      y = Icum-Inf3D_BI_O(tcum);  
   endfunction    
       

//    FOnction BEST WR 2T         
   function y = Inf3D_WR(x)
        y1 = Ss(1)*x^0.5//+B*C/b_end*Ss^2*x+A*Ss^2*x; 
        y2=-Ss(1)*%pi^0.5/(2*Ss(2)^0.5)*erf((Ss(2)*x)^0.5)
        y3=(A*(1-B)*Ss(1)^2+B*qexpinf)*x 
        y4=-(A*(1-B)*Ss(1)^2+B*qexpinf)*(1-exp(-Ss(2)*x))/Ss(2)   
        y=y1+y2+y3+y4      
   endfunction 
  
   function y = er_sol_WR(Ss,m)
      y = I_sci(1:n1_end)-Inf3D_WR(t_sci(1:n1_end));  
   endfunction    
   
 //     Fonction BEST WR 3T
   function y = Inf3D_3T_WR(x)
        y1 = Ss(1)*x^0.5
        y2=-Ss(1)*%pi^0.5/(2*Ss(2)^0.5)*erf((Ss(2)*x)^0.5)
        y3=(A*(1-B)*Ss(1)^2+B*qexpinf)*x 
        y4=-(A*(1-B)*Ss(1)^2+B*qexpinf)*(1-exp(-Ss(2)*x))/Ss(2)  
        y5=0.76/9*(qexpinf-A*Ss(1)^2)^2/Ss(1)*x^1.5
        y6=-0.76/6*(qexpinf-A*Ss(1)^2)^2/Ss(1)
        y7=-x^0.5/Ss(2).*exp(-Ss(2)*x)+%pi^0.5/2/Ss(2)^1.5*erf((Ss(2)*x)^0.5)   
        y=y1+y2+y3+y4+y5+y6*y7      
   endfunction   
  
  
   function y = er_sol_3T_WR(Ss,m)
      y = I_sci-Inf3D_3T_WR(t_sci);  
   endfunction   

