
//////////////////  calcul adimenssionnel //////////////////////////////////

// fonctions hydrodynamiques adimensionnelles

  function y = Se_(ttheta,theta_r,theta_s)          // calcul de Se correspondant à une valeur de theta
    y = (ttheta-theta_r)/(theta_s-theta_r);
  endfunction
  
  // Brooks & Corey model

  function y = Se_vGB(h,hg,n)                // modèle van genuchten
    m = 1-2/n;
    y = (1+(h./hg).^n).^(-m);
  endfunction
       
  function y = wcr_vGB_(t,theta_r,theta_s,n)
    y=((Se_(t,theta_r,theta_s)).^(-n/(n-2))-1).^(1/n)
    endfunction
    
  function  y = Kr_vGB(SSe,eta)
    y = SSe.^eta;
  endfunction
  
  // Mualem model
  
  function y = Se_vGM(h,hg,n)                // modèle van genuchten
    m = 1-1/n;
    y = (1+(h./hg).^n).^(-m);
  endfunction
       
  function y = wcr_vGM_(t,theta_r,theta_s,n)
    y=((Se_(t,theta_r,theta_s)).^(-n/(n-1))-1).^(1/n)
    endfunction
    
  function  y = Kr_vGM(SSe,n,l)
    m = 1-1/n;  
    y = SSe.^l.*(1-(1-SSe.^(1/m)).^m).^2;
  endfunction
  
// fonctions hydrodynamiques dimensionnelles

  // Brooks & Corey model

 function y = theta_vGB(h,hg,theta_r,theta_s,n)
    y = theta_r+(theta_s-theta_r)*Se_vGB(h,hg,n);
  endfunction
  
  function y = K_vGB(Ks,t,theta_r,theta_s,eta)
    Se_t = Se_(t,theta_r,theta_s); 
    y = Ks*Kr_vGB(Se_t,eta);
  endfunction
  
  function y = wcr_vGB(t,theta_r,theta_s,hg,n)
    y = hg*wcr_vGB_(t,theta_r,theta_s,n);
  endfunction
  
  // Mualem model
   
 function y = theta_vGM(h,hg,theta_r,theta_s,n)
    y = theta_r+(theta_s-theta_r)*Se_vGM(h,hg,n);
  endfunction
  
  function y = K_vGM(Ks,t,theta_r,theta_s,n,l)
    Se_t = Se_(t,theta_r,theta_s); 
    y = Ks*Kr_vGM(Se_t,n,l);
  endfunction
  
  function y = wcr_vGM(t,theta_r,theta_s,hg,n)
    y = hg*wcr_vGM_(t,theta_r,theta_s,n);
  endfunction

// calcul de sorptivité --- fonctions adimensionnelles
   
  // Brooks & Corey model
   
   function y = dh_dS_vGB(xS,n)
     y = -1/(n-2)*xS^(-n/(n-2)-1)*(xS^((-n)/(n-2))-1)^(1/n-1);
   endfunction
   
  function y = D_etoile_vGB(xS,n,eta)
    y = Kr_vGB(xS,eta)*dh_dS_vGB(xS,n);
  endfunction
         
  function y = S_etoile_2_int_vGB(xS,Se0,Sef,n,eta)
    y=(Sef+xS-2*Se0)*D_etoile_vGB(xS,n,eta);
    endfunction
  
 function y = S_etoile_2_vGB(Se0,Sef,n,eta)
    y = intg(Se0,Sef,S_etoile_2_int_vGB);
  endfunction
  
  // Mualem model
  
   function y = dh_dS_vGM(xS,n)
     y = -1/(n-1)*xS^(-n/(n-1)-1)*(xS^((-n)/(n-1))-1)^(1/n-1)
   endfunction
   
  function y = D_etoile_vGM(xS,n,l)
    y = Kr_vGM(xS,n,l)*dh_dS_vGM(xS,n)
  endfunction
         
  function y = S_etoile_2_int_vGM(xS,Se0,Sef,n,l)
    y=(Sef+xS-2*Se0)*D_etoile_vGM(xS,n,l)          
    endfunction
  
 function y = S_etoile_2_vGM(Se0,Sef,n,l)
    y = intg(Se0,Sef,S_etoile_2_int_vGM)
  endfunction
 
 // calcul de sorptivité --- fonctions dimensionnelles
  
  // Brooks & Corey model
  
  function y = S_2_vGB(h0,hf,theta_r,theta_s,hg,Ks,n,eta)
    Se0 = Se_vGB(h0,hg,n);
    Sef = Se_vGB(hf,hg,n); 
    S_etoile_2_ = S_etoile_2_vGB(Se0,Sef,n,eta);
    y = Ks*hg*(theta_s-theta_r)*S_etoile_2_;
  endfunction   
   
  function y = S_2_vGB_(theta_0,theta_f,theta_r,theta_s,hg,Ks,n,eta)
    Se0 = Se_(theta_0,theta_r,theta_s);
    Sef = Se_(theta_f,theta_r,theta_s); 
    S_etoile_2_ = S_etoile_2_vGB(Se0,Sef,n,eta);
    y = Ks*hg*(theta_s-theta_r)*S_etoile_2_;
  endfunction
  
  // Mualem model
  
  function y = S_2_vGM(h0,hf,theta_r,theta_s,hg,Ks,n,l)
    Se0 = Se_vGM(h0,hg,n);
    Sef = Se_vGM(hf,hg,n); 
    S_etoile_2_ = S_etoile_2_vGM(Se0,Sef,n,l);
    y = Ks*hg*(theta_s-theta_r)*S_etoile_2_;
  endfunction   
   
  function y = S_2_vGM_(theta_0,theta_f,theta_r,theta_s,hg,Ks,n,l)
    Se0 = Se_(theta_0,theta_r,theta_s);
    Sef = Se_(theta_f,theta_r,theta_s); 
    S_etoile_2_ = S_etoile_2_vGM(Se0,Sef,n,l);
    y = Ks*hg*(theta_s-theta_r)*S_etoile_2_;
  endfunction   
    
    // définition des coefficients de passages
    
    function y = gamma_vGB_(h0,hf,theta_r,theta_s,hg,Ks,n,eta) // S_2(h0,hf,theta_r,theta_s,hg,Ks,n,eta)
      Se0_ = Se_vGB(h0,hg,n);
      Sef_ = Se_vGB(hf,hg,n);
      y_S_2 =  S_2_vGB(h0,hf,theta_r,theta_s,hg,Ks,n,eta);
      y_delta_K = Ks*(Kr_vGB(Sef_,eta) - Kr_vGB(Se0_,eta));
      y(1,1) = y_S_2/(2*y_delta_K);
      y(2,1) = y_S_2/(2*y_delta_K^2);
    endfunction
    
    function y = gamma_vGM_(h0,hf,theta_r,theta_s,hg,Ks,n,l)
      Se0_ = Se_vGM(h0,hg,n);
      Sef_ = Se_vGM(hf,hg,n);
      y_S_2 =  S_2_vGM(h0,hf,theta_r,theta_s,hg,Ks,n,l);
      y_delta_K = Ks*(Kr_vGM(Sef_,n,l) - Kr_vGM(Se0_,n,l));
      y(1,1) = y_S_2/(2*y_delta_K);
      y(2,1) = y_S_2/(2*y_delta_K^2);
    endfunction
                 
                 
/// functions for optimization of parameter hg

// fitting h(Se) function

//    function y = wcr_vGB_O(Se,n)
//      y = hhg*(Se.^(-n/(n-2))-1).^(1/n);
//    endfunction
//    
//     function y = er_sol_hg_1(p2,m)
//        hhg = p2(1);
//        y = h_data-wcr_vGB_O(Se_data,n_vGB);  
//     endfunction     
//    
//// fitting Se(h) function
//
//    function y = Se_vGB_O(h,n)
//        y = (1+(h./hhg).^n).^(-(1-2/n));
//    endfunction
//    
//     function y = er_sol_hg_2(p2,m)
//        hhg = p2(1);
//        y = Se_data-Se_vGB_O(h_data,n_vGB);  
//     endfunction     

/// functions for optimization of parameter hg

// functions for shape parameters

 function y = eta_function(n,p)
   y = 2/(n-2)+p+2;
 endfunction
 
 function y = m_function(n,km)
   y = 1-km/n;
 endfunction 
 
 
 function y=cp_function(n)
   m = 1-2/n;
   eta = 2/(n-2)+3;
   t1 = 1+1/n;
   t2 = m*eta-1/n;
   t3 = m*eta;
   t4 = m*eta+m-1/n;
   t5 = m*eta+m;
   y = gamma(t1)*mtlb_a(gamma(t2)/gamma(t3),gamma(t4)/gamma(t5));;
 endfunction
 
  function y = hg_function(theta0,thetas,Ks,S,eta,cp)
    y =  -S^2/(cp*(thetas-theta0)*(1-(theta0/thetas)^eta)*Ks);
  endfunction
  
