// README

    txt_intro = ['BEST Method:';'PSD Analysis:';'Do you want to see example for input file? (yes or no)'];
    txt_intro_2 =['BEST-Intercept';'Minasny method';'no'];
    
    if kk_method == 1 then rep_intro = x_mdialog('BEST version 001',txt_intro,txt_intro_2);
    end
    
     if rep_intro ==[] then
        chdir(T1);
        x_mdialog('BEST program is ended','Caution: remove files from \Result and \Figures folders','Press ok');
        abort;
     end

// Presentation of the method
  
  ltxt(1) = "1.200  0        ";
  ltxt(2) = "2.650  0        ";
  ltxt(3) = "0.169  0        ";
  ltxt(4) = "75.00  0        ";
  ltxt(5) = "0.002  0.45     ";
  ltxt(6) = "0.500  0.55     ";
  ltxt(7) = "2.000  0.55     ";
  ltxt(8) = "0      0        ";
  ltxt(9) = "60     3.961    ";
  ltxt(10) = "..     ..       ";
  ltxt(11) = "4134   71.301   ";
  ltxt(12) = "0     0         ";
  ltxt(13) = "Need more info? ";
  
  ltxtr(1) = "bulk density (g/cm^3) / separator";
  ltxtr(2) = "mineral density (g/cm^3) / separator";
  ltxtr(3) = "initial water content (cm^3/cm^3) / separator";
  ltxtr(4) = "radius of the source (mm) / separator";
  ltxtr(5) = "particle diameter D (mm) and cumulative frequency FF (g/g) (d < 0.002 mm, i.e. clay)";
  ltxtr(6) = "particle diameter D (mm) and cumulative frequency FF (g/g) (d < 0.500 mm, i.e. clay+silt)";
  ltxtr(7) = "particle diameter D (mm) and cumulative frequency FF (g/g) (d < 2.000 mm, i.e. clay+silt+sand)";
  ltxtr(8) = "separator";
  ltxtr(9) = "time (s) Cumulative Infiltration (mm) -  first point";
  ltxtr(10) = "time (s) Cumulative Infiltration (mm) -  point #n";
  ltxtr(11) = "time (s) Cumulative Infiltration (mm) -  last point";
  ltxtr(12) = "final separator ";
  ltxtr(13) = "see example_MM.txt file in \Data folder";
  
  if rep_intro(3) == "yes" then 
     x_mdialog('Description of input file',ltxt,ltxtr);
     rep_intro(3) = "no";
  end


// Initialization
  
  fig_factor = 1.5;                            // factor for figure scaling
  data_factor = 1.2;                           // factor for modeling generated data
  i_fig = 1;
  
  close_windows(20);
  
// ---- 0. Uploads -------------------------------  

    
// Upload tool and BEST functions
    
        file_name_  = uigetfile(['*.txt'],T2,'Select data file');
        
        if file_name_ == '' then
            chdir(T1);
            x_mdialog('BEST program is ended','Caution: remove files from \Result and \Figures folders','Press ok');
            abort;
        end
        
        ll1 = length(T2);
        ll2 = length(file_name_);
        file_name = part(file_name_,(length(T2)+2):(length(file_name_)-4));
        
        
//    pause
        
// first inputs
       
    entry = read(file_name+'.txt',-1,2);           //--> data file
    nbl = size(entry,1);                           // number of line of data file

    dens_app = entry(1,1);                         // bulk density [g/cm^3]
    dens_min = entry(2,1);                         // mineral density [g/cm^3]
    theta0 = entry(3,1);                          // initial water content [%]
    rd = entry(4,1);                               // ring radius [mm]
    
    porosity = 1 - dens_app/dens_min;
    thetas = porosity;

   //  reading experimental PSD
  
   clear X1 Y1
  
    jj0 = 5;
    jj = jj0;
    
      while (entry(jj,1)~=0);
        X1(jj-jj0+1,1) = entry(jj,1);
        Y1(jj-jj0+1,1) = entry(jj,2);
       jj = jj+1;
    end
    
    ps = (Y1(3)-Y1(2))/Y1(3)*100;       // *100 to get percents
    pc = (Y1(1)/Y1(3))*100;
    
    //  reading experimental I(t)

   clear X2 Y2
   clear X2_ Y2_

    jj = jj+1;
    c0 = jj;

    while (entry(jj,1)~=0);
        X2_(jj+1-c0,1) = entry(jj,1);
        Y2_(jj+1-c0,1) = entry(jj,2);
       jj = jj+1;
      end
   
    X2 = [0;X2_];
    Y2 = [0;Y2_];
    
    
//----  I. BEST ESTIMATION OF WATER RETENTION CURVE (WCR) AND HYDRAULIC CONDUCTIVITY (K) SHAPE PARAMETERS -----

// Truncation of data
    
    // Fractal dimension

    e = 1-dens_app/dens_min;
    s = sfractal(e,0.5);                   // Equations 13 Lassabatere et al. (2006)

// Derivation of shape parameters

    n = n_function_MM(ps,pc);                   // Equations from Minasney 
    m = m_function(n,2);                        // 2 because Burdine function
    eta = eta_function(n,1);                    // 1 because Burdine capillarity model 

// Estimation of coefficient cp 
    
    cp = cp_function(n);
    
    
//----  III. COMPARISON MINASMEY AND BEST -----
    
   txt_psd_1 = ['n';'eta'];
   txt_psd_2 =[string(n);string(eta)];
   
    x_mdialog('shape parameters',txt_psd_1,txt_psd_2);
    
    
 
//---  II. CONSTANTS -------------------------------------------------------------------------------


// constants

    gammaa = 0.75;               // on supprime línfiltration laterale 3D
    betaa = 0.6;
    thetar = 0;

// coefficients A B C and W

     A = gammaa/(rd*(thetas-theta0));
     B =((2-betaa)/3)*(1-(theta0/thetas)^eta) + (theta0/thetas)^eta;             
     C =  1/(2*(1-(theta0/thetas)^eta)*(1-betaa))*log(1/betaa);    
     W = (theta0/thetas)^eta;
     delta_Kr_0 = (1-W);
     
     
//--- III SELECTION AND ANALYSIS OF THE EXPERIMENTAL DATA ---------------------------------------

// selection and improvment of data

     rep_data = 'no';
 
     while rep_data == 'no';
         
     txt_data_1 = 'Choice of experimental data !';    
     txt_data_2 = ['First point [1'+':'+string(size(X2,1))+']';'Last point  [1'+':'+string(size(X2,1))+']';'Initialize ? 0 for no and 1 for yes'];
     sig_data = x_mdialog(txt_data_1,txt_data_2,['1';string(size(Y2,1));'0']);
     
     if sig_data ==[] then
        chdir(T1);
        x_mdialog('BEST program is ended','Caution: remove files from \Result and \Figures folders','Press ok');
        abort;
     end
     
     n_data_1 = evstr(sig_data(1));
     n_data_2 = evstr(sig_data(2));
     Initialize = evstr(sig_data(3));


// 1.2  reduction and selection of data

    n_red = [n_data_1;n_data_2;1];                           //-->> by default no truncation of data. Yet, this can be truncated if necessary
    n_red_ = [n_red(1):n_red(3):n_red(2)];     
  
    t_sci = reduc(X2,n_red(1),n_red(2),n_red(3),Initialize);     // selected data to be treated by default equals the complete dataset
    I_sci = reduc(Y2,n_red(1),n_red(2),n_red(3),Initialize);
    
    t_sci_2 = t_sci([2:1:size(t_sci,1)],:);                     // plot I/t^0.5 versus t^0.5 corresponding to the truncated data
    I_sci_2 = I_sci([2:1:size(I_sci,1)],:);
    
    n_tot_ = size(t_sci,1);
    
    X2_2 = X2([2:1:size(X2,1)],:);                              //transformed data to plot I/t^0.5 versus t^0.5
    Y2_2 = Y2([2:1:size(Y2,1)],:);
    
    
// 1.2  infiltration rate curve qexp(t)

    zqexp = qexp(X2,Y2);                                        // infiltration rate related to the whole dataset
    tqexp = zqexp(:,1);
    qqexp = zqexp(:,2);

    zqexp_sci = qexp(t_sci,I_sci);                             // infiltration rate related to the selected dataset
    tqexp_sci = zqexp_sci(:,1);
    qqexp_sci = zqexp_sci(:,2);

     clf(i_fig);
     scf(i_fig);
     
     i_fig = i_fig+1;
     
     subplot(2,2,1)
      plot(X2,Y2,'*-',X2(n_red_,:),Y2(n_red_,:),'o-','Markersize',7);  
      a = gca();
      a.data_bounds = [0,0;max(X2),fig_factor*max(Y2)];    
      xlabel('t [s]');  
      ylabel('I [mm]');
      legend('whole dataset','chosen dataset');   
      title('whole dataset and selected data');  
      
      subplot(2,2,3)
      plot(X2,Y2,'*-',t_sci,I_sci,'o-','Markersize',7);  
      a = gca();
      a.data_bounds = [0,0;max(X2),fig_factor*max(Y2)];  
      xlabel('t [s]');  
      ylabel('I [mm]');
      legend('whole dataset','new dataset');  
      title('original data and modified'); 
      
      subplot(2,2,2)
      plot(X2_2.^(0.5),Y2_2./X2_2.^(0.5),'*-',t_sci_2.^(0.5),I_sci_2./t_sci_2.^(0.5),'o-','Markersize',7);  
      a = gca();
      a.data_bounds = [0,0;max(X2_2.^(0.5)),fig_factor*max(Y2_2./X2_2.^(0.5))];  
      xlabel('t^0.5 [s]');  
      ylabel('I/t^0.5 [mm/s^0.5]');
      legend('whole dataset','new dataset');  
      title('I/t^0.5=f(t^0.5) should be linear');  
              
//      subplot(2,2,4)
//      plot(tqexp,qqexp,'*-',tqexp_sci,qqexp_sci,'o-','Markersize',7)
//      a = gca();
//      a.data_bounds = [0,0;max(tqexp),1.5*max(qqexp)];   
//      xlabel('t [s]');  
//      ylabel('q [mm/s]');
//      legend('whole dataset','new dataset');
//      title('infiltrations rates to be validated');
//      

      rep_data = x_mdialog('End of choice','Satisfied ?','yes');
      
      if rep_data ==[] then
        chdir(T1);
        x_mdialog('BEST program is ended','Caution: remove files from \Result and \Figures folders','Press ok');
        abort;
      end
      
      end
      
      
// --- IV CL METHOD ----------------------------------------------------

     X_cL = t_sci_2.^0.5;                                            // CL transformation applied to the dataset
     Y_cL = I_sci_2./X_cL;
     
     n_cl_1 = 1;
     n_cl_2 = size(Y_cL,1);
     
     n_red_cl = [n_cl_1;n_cl_2;1];                                //-->> choice of points related to the CL method.
     n_red_cl_ = [n_red_cl(1):n_red_cl(3):n_red_cl(2)];
                       
     X_cL_r = X_cL(n_red_cl_,:);
     Y_cL_r = Y_cL(n_red_cl_,:);
  
     sol_CL_ = sol_CL(t_sci_2,I_sci_2,n_red_cl(1),n_red_cl(2),n_red_cl(3));          //-->> rentrer les pts délimitant la zone linéaire
     
     S_CL = sol_CL_(2);
     Ks_CL = sol_CL_(1);
       
     Y_cL_mod = S_CL+(B*Ks_CL+A*S_CL^2)*X_cL;
     
     clf(i_fig);
     scf(i_fig);
     
     i_fig = i_fig+1;
     
     plot(X_cL,Y_cL,'*',X_cL_r,Y_cL_r,'o',X_cL,Y_cL_mod,'-','Markersize',7);  
      a = gca();  
      xlabel('t^0.5 [s^0.5]');  
      ylabel('I/t^0.5 [mm/s^0.5]');
      legend('data','chosen data');  
      title('Cumulative Linearisation');
      

// --- V BEST BS METHOD ----------------------------------------------------

     rep_BI = 'no';
     n2_end = size(t_sci,1);
     n1_end = n2_end-2;
     Fact_Ks = 10^-1;
     
     while rep_BI == 'no';
      
       txt_nend_1 = ['first point for steady state? [1'+':'+string(size(X2,1))+']';'last point for steady state? [1'+':'+string(size(X2,1))+']'];
       txt_nend_2 = [string(n1_end);string(n2_end)];
     
       rep_nend = x_mdialog('Selection of Steady State',txt_nend_1,txt_nend_2);
       
       if rep_nend ==[] then
          chdir(T1);
          x_mdialog('BEST program is ended','Caution: remove files from \Result and \Figures folders','Press ok');
          abort;
       end
  
       n1_end = evstr(rep_nend(1));
       n2_end = evstr(rep_nend(2));
       
       n_bi_end = [n1_end:1:n2_end];
       
       t_exp_end = t_sci(n_bi_end,:);
       I_exp_end = I_sci(n_bi_end,:);
       
       n_end = size(t_exp_end,1);
  
       n_bi = [2:1:size(t_sci,1)];                         //-->> begin with 2 to avoid the first point (0,0) for the fit --> worsens the results 
    
       t_exp = t_sci(n_bi,:);                               // !! t_exp and I_exp are defined as experimental data to be fitted to in objective functions
       I_exp = I_sci(n_bi,:);
       
       coeff_ = ab_end(t_exp_end,I_exp_end,n_end);
       qexpinf = coeff_(2,1);
       b_end = max(coeff_(1,1),I_sci(1));                   // sécurité pour assurer le calcul
       
       S0 = S_CL;
       
       if S0 < 0 then S0 = (qexpinf/(2*A))^(1/2);           //-->> if S0 < 0 we consider half of the steday state is related to sorptivity
           end;
              
       lI = size(I_exp,1);
       kk = [1:lI]';
       
       S_opt_ = zeros(lI,1);
       t_max_ = zeros(lI,1);
       Ks_opt_ = zeros(lI,1);
       
       for k = 2:lI;
           Icum = I_exp(1:k,1);
           tcum = t_exp(1:k,1);
           [p2,v2] = lsqrsolve(S0,er_sol_BI,size(Icum,1));
           S_opt_(k,1) = p2;
           Ks_opt_(k,1) = C*p2^2/b_end;
           t_max_(k,1) = 1/(4*(1-B)^2)*(p2/(C*p2^2/b_end))^2;
       end;
      
         k_valid = (((t_max_-t_exp)./(abs(t_max_-t_exp))+1)/2).*kk;
         kstep = max(2,max(k_valid));
         
       if max(k_valid) == 0 & coeff_(1,1) > 0 then
         x_mdialog('CAUTION','No point could be found with t_exp < t_max --> transient state restricted to 2 points','Press ok');end;
         
         S_opt = S_opt_(kstep);
         Ks_opt = Ks_opt_(kstep);
         
       if coeff_(1,1) < 0 then
            txt_fracKs_1 = ["Ks fixed at the part of the total flux";'S estimated to keep the same final flux'];
            txt_fracKs_2 = [string(Fact_Ks);'Press Ok'];
            sig_fracKs = x_mdialog('CAUTION - Erroneous estimates',txt_fracKs_1,txt_fracKs_2);
            
            if sig_fracKs ==[] then
                chdir(T1);
                x_mdialog('BEST program is ended','Caution: remove files from \Result and \Figures folders','Press ok');
                abort;
            end 
            
            Fact_Ks = evstr(sig_fracKs(1));
            Ks_opt = Fact_Ks*qexpinf;
            S_opt = (qexpinf*(1-Fact_Ks)/A)^(1/2);
       end;
         
     t_max = 1/(4*(1-B)^2)*(S_opt/Ks_opt)^2;
         
     p_opt = [Ks_opt S_opt];
         
     hg_opt = hg_function(theta0,thetas,Ks_opt,S_opt,eta,cp);

// plots of solutions
         
     clf(i_fig);
     scf(i_fig);
     
     i_fig = i_fig+1;
     
     subplot(2,2,1)
      plot(kk,S_opt_,'*',kstep,S_opt_(kstep),'o',kstep,S_opt,'ro','Markersize',7);  
      a = gca();
      a.data_bounds = [1,0;max(kk),fig_factor*max(S_opt_)];  
      xlabel('kk');  
      ylabel('S_opt');
      legend('S_opt(n)','S_opt(kstep)','S_opt');    
      title('S estimation');  
      
      subplot(2,2,2)
      plot(kk,Ks_opt_,'*',kstep,Ks_opt_(kstep),'o',kstep,Ks_opt,'ro','Markersize',7); 
      b = gca();
      b.data_bounds = [1,0;max(kk),fig_factor*max(Ks_opt_)];    
      xlabel('kk');  
      ylabel('Ks_opt');
      legend('Ks_opt(n)','Ks_opt(kstep)','Ks_opt');  
      title('Ks estimation');  
              
      subplot(2,2,3)
      plot(kk,t_exp,'+',kk,t_max_,'*',kstep,t_max_(kstep),kstep,t_max,'ro','Markersize',7); 
      c = gca();
      c.data_bounds = [1,0;max(kk),fig_factor*max([t_max_;t_exp])];    
      xlabel('kk');  
      ylabel('t');
      title('time validity: texp < tmax');
      
      subplot(2,2,4)
      plot(kk,t_exp,'+',kk,t_max_,'*',kstep,t_max_(kstep),kstep,t_max,'ro','Markersize',7); 
      c = gca();
      c.data_bounds = [1,0;max(kk),fig_factor*max([max([t_max_;t_exp]) t_max])];    
      xlabel('kk');  
      ylabel('t');
      legend('texp','tmax','tmax(kstep)','tmax(S_opt,Ks_opt)');
      title('time validity: texp < tmax');
      
      
//      pause
      
  
// --- VI CALCULUS OF THE MODEL and comparison with experimental data ----------------------------------------------------


    Ks = Ks_opt;
    K0 = Ks_opt*W;
    S = S_opt;
    
    u = 0.6;
    v = 0.75;
    
    t_mod = [0:t_sci(2):t_sci($)]';
    I_mod = I_3D(t_mod,Ks,K0,S,rd,thetas,theta0,u,v);
    I_sst = I_sst_3D(t_mod,Ks,K0,S,rd,thetas,theta0,u,v);
    
    I_mod_sci = I_3D(t_sci,Ks,K0,S,rd,thetas,theta0,u,v);

    t_trans = [0:t_max/100:t_max]';
    I_trans = I_trans_3D(t_trans,Ks,K0,S,rd,thetas,theta0,u,v);
    
    
// infiltrations rates

    q_mod = qexp(t_mod,I_mod);
    tq_mod = q_mod(:,1);
    qq_mod = q_mod(:,2);
    
    q_mod_sci = interpol(tqexp_sci,tq_mod,qq_mod);
    
    q_trans = qexp(t_trans,I_trans);
    tq_trans = q_trans(:,1);
    qq_trans = q_trans(:,2);
    
    q_sst = qexp(t_mod,I_sst);
    tq_sst = q_sst(:,1);
    qq_sst = q_sst(:,2);
    
// Relative errors

    Er_I_sci = (I_mod_sci-I_sci)./I_sci*100;
    Er_I_sci(1,1) = 0;                                                                // 0/0 but in fact 0 = 0 !
    Er_q_sci = (q_mod_sci-qqexp_sci)./qqexp_sci*100;
    
    // plots
    
    n_end_r = [n1_end:1:n2_end];
    n_end_rq = [n1_end:1:(n2_end-1)];

     clf(i_fig);
     scf(i_fig);
     
     i_fig = i_fig+1;
     
     subplot(2,2,1)
      plot(t_sci,I_sci,'bk*',t_sci(n_end_r,:),I_sci(n_end_r,:),'bko',t_mod,I_mod,'g-',t_trans,I_trans,'r-',t_mod,I_sst,'b--','Markersize',7);  
      a = gca();
      a.data_bounds = [0,0;max(t_sci),fig_factor*max(I_sst)];   
      xlabel('t [s]');  
      ylabel('I [mm]');
      title('Cumulative Infiltration I(t)');  
      
      subplot(2,2,2)
      plot(tqexp_sci,qqexp_sci,'bk*',tqexp_sci(n_end_rq,:),qqexp_sci(n_end_rq,:),'bko',tq_mod,qq_mod,'g-',tq_trans,qq_trans,'r-',tq_sst,qq_sst,'b--','Markersize',7);  
      a = gca();
      a.data_bounds = [0,0;max(tqexp_sci),fig_factor*10*qexpinf];  
      xlabel('t [s]');  
      ylabel('q [mm/s]');
      legend('data','used for steady state','complete model','transient model','steady state model',1); 
      title('Infiltration rate q(t)');  
              
      subplot(2,2,3)
      plot(t_sci,Er_I_sci,'ro-',t_sci,zeros(size(t_sci,1),1),'bk-','Markersize',7)
      a = gca();
      a.data_bounds = [0,-fig_factor*max(abs(Er_I_sci));max(t_sci),fig_factor*max(abs(Er_I_sci))];  
      xlabel('t [s]');  
      ylabel('Er (%)');
      title('Relative errors for I(t)');      
      
      subplot(2,2,4)
      plot(tqexp_sci,Er_q_sci,'ro-',tqexp_sci,zeros(size(tqexp_sci,1),1),'bk-','Markersize',7)
      a = gca();
      a.data_bounds = [0,-fig_factor*max(abs(Er_q_sci));max(t_sci),fig_factor*max(abs(Er_q_sci))]; 
      xlabel('t [s]');  
      ylabel('Er (%)');
      title('Relative errors for q(t)');
      
//      pause
      
     rep_BI = x_mdialog('Results of BEST modelling','Are you satisfied ?','yes');
     
     if rep_BI ==[] then
        chdir(T1);
        x_mdialog('BEST program is ended','Caution: remove files from \Result and \Figures folders','Press ok');
        abort;
     end
     
     end  

      
// --- VII RELATED WRF and HCF  ----------------------------------------------------

    // plots
    
      h_ = (-logspace(log(abs(hg_opt)/100)/log(10),log(100*abs(hg_opt))/log(10),200))';
      theta_vGB_ = theta_vGB(h_,hg_opt,thetar,thetas,n);
      K_vGBBC_ = K_vGB(Ks_opt,theta_vGB_,thetar,thetas,eta);
      
     clf(i_fig);
     scf(i_fig);
     
     subplot(2,2,1)
      plot(theta_vGB_,abs(h_),'b-','Markersize',2);  
     a = gca();
     xlabel('theta (%)');
     ylabel('h [mm]');
     title('Water retention curve');  
      
    subplot(2,2,2)
     plot(abs(h_),K_vGBBC_,'b-','Markersize',2);
     a = gca();
     a.log_flags = 'nnn';
     xlabel('h[mm]');
     ylabel('K [mm/s]');
     title('Hydraulic retention curve K(h)');    
     
    subplot(2,2,3)
     plot(theta_vGB_,K_vGBBC_,'b-','Markersize',2);
     a = gca();
     a.log_flags = 'nnn';
     xlabel('theta [-]');
     ylabel('K [mm/s]');
     title('Hydraulic retention curve K(theta)');
     
     
    // Results
    
    l00a = 'file name                                           ;';
    l00b = 'BEST Method                                         ;';
    l00c = 'PSD Analysis                                        ;';
    l00d = '----------------------------------------------------;';
    l0 = 'theta_r [-]                                         ;';
    l1 = 'theta_s [-]                                         ;';
    l2 = 'hg [mm]                                             ;';
    l3 = 'Ks [mm/s]                                           ;';
    l4 = 'n [-]                                               ;';
    l5 = 'eta [-]                                             ;';
    l6 = '----------------------------------------------------;';
    l7 = 'm [-]                                               ;';
    l8 = 'cp [-]                                              ;';
    l9 = 'S [mm/s^0.5]                                        ;';
    l10 = '----------------------------------------------------;';
    l11 = 'Chosen data points for PSD Analysis:                ;';
    l12 = 'Chosen data points for Cumulative Infiltration:     ;';
    l13 = 'Initialization ?                                    ;';
    l14 = 'Chosen data points for steady state:                ;';
    
    lr00a = file_name;
    lr00b = 'BEST-Intercept';
    lr00c = 'Minasny';
    lr00d = '------';
    lr0 = string(thetar);
    lr1 = string(thetas);
    lr2 = string(hg_opt);
    lr3 = string(Ks_opt);
    lr4 = string(n);
    lr5 = string(eta);
    lr6 = '------';
    lr7 = string(m);
    lr8 = string(cp);
    lr9 = string(S_opt);
    lr10 = '------';
    lr11 = 'ps and pc';
    lr12 = string(n_data_1)+':'+string(n_data_2)+' out of '+string(size(X2,1));
    if Initialize == 1 then lr13 = 'yes';
        else lr13 = 'no';
    end
    
    //lr14 = string(n_cl_1)+':'+string(n_cl_2)+' out of '+string(size(t_sci_2,1));
    lr14 = string(n1_end)+':'+string(n2_end)+' out of '+string(size(t_sci,1));


    
    txt_result_1 = 'BEST Hydraulic parameters';
    txt_result_2_ = [l00a;l00b;l00c;l00d;l0;l1;l2;l3;l4;l5;l6;l7;l8;l9;l10;l11;l12;l13;l14];
    txt_result_3 = [lr00a;lr00b;lr00c;lr00d;lr0;lr1;lr2;lr3;lr4;lr5;lr6;lr7;lr8;lr9;lr10;lr11;lr12;lr13;lr14];
    
    for i = 1:size(txt_result_2_,1)
        txt_result_2(i) = part(txt_result_2_(i),1:(length(txt_result_2_(i))-1));
    end


    x_mdialog(txt_result_1,txt_result_2,txt_result_3);
printf('taguele')
//     pause

// --- SAVINGS ----------------------------------------------------

      
    Result = txt_result_2_+txt_result_3;
    HCWRF = [h_ theta_vGB_ K_vGBBC_];
   
    T4 = T1+'\Result';

    T4 = uigetdir(T4,'Go to Result directory');
    chdir(T4);
    
    if T4 == '' then
        chdir(T1);
        x_mdialog('BEST program is ended','Caution: remove files from \Result and \Figures folders','Press ok');
        abort;
    end
    
     txt_saving = ['Save Result data?';'Save HCWRF data?';'Save figures?';'File name for results?';'File name for HCWRF?'];
     txt_saving_2 = ['no';'no';'no';'BEST-Intercept-MM_Results_'+file_name;'BEST-Intercept-MM_HCWRF_'+file_name];
     sig_saving = x_mdialog('Savings',txt_saving,txt_saving_2);
     
     if sig_saving == [] then
        chdir(T1);
        x_mdialog('BEST program is ended','Caution: remove files from \Result and \Figures folders','Press ok');
        abort;
     end
     
     Save_result = sig_saving(1);
     Save_HCWRF = sig_saving(2);
     Save_Fig = sig_saving(3);
     Result_name = sig_saving(4);
     HCWRF_name = sig_saving(5);

    if Save_result == 'yes' then
//        erase_file(Result_name+'.txt');
        write(Result_name+'.txt',Result);
    end;

    if Save_HCWRF == 'yes' then
//        erase_file(HCWRF_name+'.txt');
        write(HCWRF_name+'.txt',HCWRF);
    end;
    
    chdir(T4+'\Figures');
    
    if Save_Fig == 'yes' then
        for i = 1:i_fig
            xs2bmp(i,'BEST-Intercept-MM_'+file_name+'_fig'+string(i));
        end
    end;
    
    chdir(T2);
    

    
    
    
   
   

