// README

    txt_intro = ['BEST Method:';'PSD Analysis:';'Do you want to see example for input file? (yes or no)'];
    txt_intro_2 =['BEST-3T-WR';'Minasny method';'no'];

    if kk_method==1 then rep_intro = x_mdialog('BEST version 001',txt_intro,txt_intro_2);
    end
    
     if rep_intro ==[] then
        chdir(T1);
        x_mdialog('BEST program is ended','Caution: remove files from \Result and \Figures folders','Press ok');
        abort;
     end
    
// Presentation of the method
  
  ltxt(1) = "1.200  0        ";
  ltxt(2) = "2.650  0        ";
  ltxt(3) = "0.169  0        ";
  ltxt(4) = "75.00  0        ";
  ltxt(5) = "0.002  0.45     ";
  ltxt(6) = "0.500  0.55     ";
  ltxt(7) = "2.000  0.55     ";
  ltxt(8) = "0      0        ";
  ltxt(9) = "60     3.961    ";
  ltxt(10) = "..     ..       ";
  ltxt(11) = "4134   71.301   ";
  ltxt(12) = "0     0         ";
  ltxt(13) = "Need more info? ";
  
  ltxtr(1) = "bulk density (g/cm^3) / separator";
  ltxtr(2) = "mineral density (g/cm^3) / separator";
  ltxtr(3) = "initial water content (cm^3/cm^3) / separator";
  ltxtr(4) = "radius of the source (mm) / separator";
  ltxtr(5) = "particle diameter D (mm) and cumulative frequency FF (g/g) (d < 0.002 mm, i.e. clay)";
  ltxtr(6) = "particle diameter D (mm) and cumulative frequency FF (g/g) (d < 0.500 mm, i.e. clay+silt)";
  ltxtr(7) = "particle diameter D (mm) and cumulative frequency FF (g/g) (d < 2.000 mm, i.e. clay+silt+sand)";
  ltxtr(8) = "separator";
  ltxtr(9) = "time (s) Cumulative Infiltration (mm) -  first point";
  ltxtr(10) = "time (s) Cumulative Infiltration (mm) -  point #n";
  ltxtr(11) = "time (s) Cumulative Infiltration (mm) -  last point";
  ltxtr(12) = "final separator ";
  ltxtr(13) = "see example_MM.txt file in \Data folder";
  
  if rep_intro(3) == "yes" then 
     x_mdialog('Description of input file',ltxt,ltxtr);
     rep_intro(3) = "no";
  end


// Initialization
  
  fig_factor = 1.5;                            // factor for figure scaling
  data_factor = 1.2;                           // factor for modeling generated data
  i_fig = 1;
  
  close_windows(20);
  
// ---- 0. Uploads -------------------------------  

// Upload tool BEST functions and clean windows

    
// Upload tool and BEST functions
    
        file_name_  = uigetfile(['*.txt'],T2,'Select data file');
        
        if file_name_ == '' then
            chdir(T1);
            x_mdialog('BEST program is ended','Caution: remove files from \Result and \Figures folders','Press ok');
            abort;
        end
        
        ll1 = length(T2);
        ll2 = length(file_name_);
        file_name = part(file_name_,(length(T2)+2):(length(file_name_)-4));
        
//    pause
        
// first inputs
       
    entry = read(file_name+'.txt',-1,2);           //--> data file
    nbl = size(entry,1);                           // number of line of data file

    dens_app = entry(1,1);                         // bulk density [g/cm^3]
    dens_min = entry(2,1);                         // mineral density [g/cm^3]
    theta0 = entry(3,1);                          // initial water content [%]
    rd = entry(4,1);                               // ring radius [mm]
    
    porosity = 1 - dens_app/dens_min;
    thetas = porosity;

   //  reading experimental PSD
  
   clear X1 Y1
  
    jj0 = 5;
    jj = jj0;
    
      while (entry(jj,1)~=0);
        X1(jj-jj0+1,1) = entry(jj,1);
        Y1(jj-jj0+1,1) = entry(jj,2);
       jj = jj+1;
    end
    
    ps = (Y1(3)-Y1(2))/Y1(3)*100;       // *100 to get percents
    pc = (Y1(1)/Y1(3))*100;
    
    //  reading experimental I(t)

   clear X2 Y2
   clear X2_ Y2_

    jj = jj+1;
    c0 = jj;

    while (entry(jj,1)~=0);
        X2_(jj+1-c0,1) = entry(jj,1);
        Y2_(jj+1-c0,1) = entry(jj,2);
       jj = jj+1;
      end
   
    X2 = [0;X2_];
    Y2 = [0;Y2_];
    
    
//----  I. BEST ESTIMATION OF WATER RETENTION CURVE (WCR) AND HYDRAULIC CONDUCTIVITY (K) SHAPE PARAMETERS -----

// Truncation of data
    
    // Fractal dimension

    e = 1-dens_app/dens_min;
    s = sfractal(e,0.5);                   // Equations 13 Lassabatere et al. (2006)

// Derivation of shape parameters

    n = n_function_MM(ps,pc);                    // Equations 11-12 14-15 Lassabatere et al. (2006)
    m = m_function(n,2);                        // 2 because Burdine function
    eta = eta_function(n,1);                    // 1 because Burdine capillarity model 

// Estimation of coefficient cp 
    
    cp = cp_function(n);
    
    
//----  III. COMPARISON MINASMEY AND BEST -----
    
   txt_psd_1 = ['n';'eta'];
   txt_psd_2 =[string(n);string(eta)];
   
    x_mdialog('shape parameters',txt_psd_1,txt_psd_2);
    
 
//---  II. CONSTANTS -------------------------------------------------------------------------------


// constants

    gammaa = 0.75;
    betaa = 0.6;
    thetar = 0;

// coefficients A B C and W

     A = gammaa/(rd*(thetas-theta0));
     B =((2-betaa)/3)*(1-(theta0/thetas)^eta) + (theta0/thetas)^eta;             
     C =  1/(2*(1-(theta0/thetas)^eta)*(1-betaa))*log(1/betaa);    
     W = (theta0/thetas)^eta;
     delta_Kr_0 = (1-W);
     
     
//--- III SELECTION AND ANALYSIS OF THE EXPERIMENTAL DATA ---------------------------------------

// selection and improvment of data

     rep_data = 'no';
 
     while rep_data == 'no';
    
     
     txt_data_1 = 'Choice of experimental data !';    
     txt_data_2 = ['First point [1'+':'+string(size(X2,1))+']';'Last point  [1'+':'+string(size(X2,1))+']';'Initialize ? 0 for no and 1 for yes'];
     sig_data = x_mdialog(txt_data_1,txt_data_2,['1';string(size(Y2,1));'0']);
     
     if sig_data ==[] then
        chdir(T1);
        x_mdialog('BEST program is ended','Caution: remove files from \Result and \Figures folders','Press ok');
        abort;
     end
     
     n_data_1 = evstr(sig_data(1));
     n_data_2 = evstr(sig_data(2));
     Initialize = evstr(sig_data(3));


// 1.2  reduction and selection of data

    n_red = [n_data_1;n_data_2;1];                           //-->> by default no truncation of data. Yet, this can be truncated if necessary
    n_red_ = [n_red(1):n_red(3):n_red(2)];     
  
    t_sci = reduc(X2,n_red(1),n_red(2),n_red(3),Initialize);     // selected data to be treated by default equals the complete dataset
    I_sci = reduc(Y2,n_red(1),n_red(2),n_red(3),Initialize);
    
    t_sci_2 = t_sci([2:1:size(t_sci,1)],:);                     // plot I/t^0.5 versus t^0.5 corresponding to the truncated data
    I_sci_2 = I_sci([2:1:size(I_sci,1)],:);
    
    n_tot_ = size(t_sci,1);
    
    X2_2 = X2([2:1:size(X2,1)],:);                              //transformed data to plot I/t^0.5 versus t^0.5
    Y2_2 = Y2([2:1:size(Y2,1)],:);
    
    
// 1.2  infiltration rate curve qexp(t)

    zqexp = qexp(X2,Y2);                                        // infiltration rate related to the whole dataset
    tqexp = zqexp(:,1);
    qqexp = zqexp(:,2);

    zqexp_sci = qexp(t_sci,I_sci);                             // infiltration rate related to the selected dataset
    tqexp_sci = zqexp_sci(:,1);
    qqexp_sci = zqexp_sci(:,2);

    clf(i_fig);
    scf(i_fig);
    
    i_fig = i_fig+1;
     
     subplot(2,2,1)
      plot(X2,Y2,'*-',X2(n_red_,:),Y2(n_red_,:),'o-','Markersize',7);  
      a = gca();
      a.data_bounds = [0,0;max(X2),fig_factor*max(Y2)];    
      xlabel('t [s]');  
      ylabel('I [mm]');
      legend('whole dataset','chosen dataset');   
      title('whole dataset and selected data');  
      
      subplot(2,2,3)
      plot(X2,Y2,'*-',t_sci,I_sci,'o-','Markersize',7);  
      a = gca();
      a.data_bounds = [0,0;max(X2),fig_factor*max(Y2)];  
      xlabel('t [s]');  
      ylabel('I [mm]');
      legend('whole dataset','new dataset');  
      title('original data and modified'); 
      
      subplot(2,2,2)
      plot(X2_2.^(0.5),Y2_2./X2_2.^(0.5),'*-',t_sci_2.^(0.5),I_sci_2./t_sci_2.^(0.5),'o-','Markersize',7);  
      a = gca();
      a.data_bounds = [0,0;max(X2_2.^(0.5)),fig_factor*max(Y2_2./X2_2.^(0.5))];  
      xlabel('t^0.5 [s]');  
      ylabel('I/t^0.5 [mm/s^0.5]');
      legend('whole dataset','new dataset');  
      title('I/t^0.5=f(t^0.5) should be linear');  
//              
//      subplot(2,2,4)
//      plot(tqexp,qqexp,'*-',tqexp_sci,qqexp_sci,'o-','Markersize',7)
//      a = gca();
//      a.data_bounds = [0,0;max(tqexp),1.5*max(qqexp)];   
//      xlabel('t [s]');  
//      ylabel('q [mm/s]');
//      legend('whole dataset','new dataset');
//      title('infiltrations rates to be validated');
    
      rep_data = x_mdialog('End of choice','Satisfied ?','yes');
      
      if rep_data ==[] then
        chdir(T1);
        x_mdialog('BEST program is ended','Caution: remove files from \Result and \Figures folders','Press ok');
        abort;
      end

      end
      



// --- V BEST BS METHOD ----------------------------------------------------

     rep_BSst = 'no';
     
     n_end = 3;
     n1_end = size(t_sci,1)-n_end+1;
     n2_end = size(t_sci,1);
     
     Fact_Ks = 10^-1;
 
     while rep_BSst == 'no';
     
       txt_nend_1 = ['first point for steady state? [1'+':'+string(size(X2,1))+']';'last point for steady state? [1'+':'+string(size(X2,1))+']'];
       txt_nend_2 = [string(n1_end);string(n2_end)];
     
       rep_nend = x_mdialog('Selection of Steady State',txt_nend_1,txt_nend_2);
       
       if rep_nend ==[] then
          chdir(T1);
          x_mdialog('BEST program is ended','Caution: remove files from \Result and \Figures folders','Press ok');
          abort;
       end
  
       n1_end = evstr(rep_nend(1));
       n2_end = evstr(rep_nend(2));
       
       n_end_r = [n1_end:1:n2_end]';
       n_end_rq = [n1_end:1:(n2_end-1)]';
       
       [qexpinf,bs_exp,sig] = reglin(t_sci(n_end_r)',I_sci(n_end_r)');
 
 // BEST-3T-WR
       
       s0=[0.5 0.005];   //initial parameters S and alpha_WR
        [p2,v2] = lsqrsolve(s0,er_sol_3T_WR,size(t_sci,1));
        Ss=p2;S=Ss(1);alpha_WR=Ss(2);aWR=alpha_WR;
       
        S_opt = S;
        Ks_opt = qexpinf-A*S^2;;
       

       
       t_max = 1/(4*(1-B)^2)*(S_opt/Ks_opt)^2;
       p_opt = [Ks_opt S_opt];
         
       hg_opt = hg_function(theta0,thetas,Ks_opt,S_opt,eta,cp);

// plots of solutions
       
       xt_reg = [0;t_sci($)];
       yt_reg = bs_exp + qexpinf*xt_reg;
      
         
    clf(i_fig);
    scf(i_fig);
    
    i_fig = i_fig+1;
     
      plot(t_sci,I_sci,'bk*',t_sci(n_end_r),I_sci(n_end_r),'bko',xt_reg,yt_reg,'r-','Markersize',7);  
      a = gca();
      xlabel('t [s]');  
      ylabel('I [mm]');
      legend('data','used for steady state','regression',2); 
      title('Cumulative Infiltration I(t)');  
      
  
// --- VI CALCULUS OF THE MODEL and comparison with experimental data ----------------------------------------------------

    Ks = Ks_opt;
    K0 = Ks_opt*W;
    S = S_opt;
    
    u = 0.6;
    v = 0.75;
    
    t_mod_3T_WR = t_sci;
    I_mod_3T_WR= I_3D_3T_WR(t_mod_3T_WR,A,B,S,aWR,qexpinf,thetas,theta0);
 
    
// Relative errors

    Er_I_sci = ((I_mod_3T_WR-I_sci)./I_sci*100);
    Er_I_sci(1,1) = 0;                                                                // 0/0 but in fact 0 = 0 !
 
    
    // plots

    clf(i_fig);
    scf(i_fig);
    
    i_fig = i_fig+1;
    
     subplot(2,1,1)
      plot(t_sci,I_sci,'bk*',t_sci(n_end_r,:),I_sci(n_end_r,:),'bko',t_mod_3T_WR,I_mod_3T_WR,'g-',xt_reg,yt_reg,'b--','Markersize',7);  
      a = gca();
      a.data_bounds = [0,0;max(t_sci),fig_factor*max(yt_reg)];   
      xlabel('t [s]');  
      ylabel('I [mm]');
      title('Cumulative Infiltration I(t)');  
      
         
      subplot(2,1,2)
      plot(t_sci,Er_I_sci,'ro-',t_sci,zeros(size(t_sci,1),1),'bk-','Markersize',7)
      a = gca();
      a.data_bounds = [0,-fig_factor*max(abs(Er_I_sci));max(t_sci),fig_factor*max(abs(Er_I_sci))];  
      xlabel('t [s]');  
      ylabel('Er (%)');
      title('Relative errors for I(t)');      
      

      
//      pause
      
     rep_BSst = x_mdialog('Results of BEST modelling','Are you satisfied ?','yes');
     
     if rep_BSst ==[] then
        chdir(T1);
        x_mdialog('BEST program is ended','Caution: remove files from \Result and \Figures folders','Press ok');
        abort;
     end
     
     end
      
      
// --- VII RELATED WRF and HCF  ----------------------------------------------------

    // plots
    
      h_ = (-logspace(log(abs(hg_opt)/100)/log(10),log(100*abs(hg_opt))/log(10),200))';
      theta_vGB_ = theta_vGB(h_,hg_opt,thetar,thetas,n);
      K_vGBBC_ = K_vGB(Ks_opt,theta_vGB_,thetar,thetas,eta);
      
    clf(i_fig);
    scf(i_fig);
    
     subplot(2,2,1)
      plot(theta_vGB_,abs(h_),'b-','Markersize',2);  
     a = gca();
     xlabel('theta (%)');
     ylabel('h [mm]');
     title('Water retention curve');  
      
    subplot(2,2,2)
     plot(abs(h_),K_vGBBC_,'b-','Markersize',2);
     a = gca();
     a.log_flags = 'nnn';
     xlabel('h[mm]');
     ylabel('K [mm/s]');
     title('Hydraulic retention curve K(h)');    
     
    subplot(2,2,3)
     plot(theta_vGB_,K_vGBBC_,'b-','Markersize',2);
     a = gca();
     a.log_flags = 'nnn';
     xlabel('theta [-]');
     ylabel('K [mm/s]');
     title('Hydraulic retention curve K(theta)');
     
     
    // Results
    
    l00a = 'file name                                         ;';
    l00b = 'BEST Method                                       ;';
    l00c = 'PSD Analysis                                      ;';
    l00d = '--------------------------------------------------;';
    l0 = 'theta_r [-]                                       ;';
    l1 = 'theta_s [-]                                       ;';
    l2 = 'hg [L]                                           ;';
    l3 = 'Ks [L/T]                                         ;';
    l4 = 'n [-]                                             ;';
    l5 = 'eta [-]                                           ;';
    l6 = 'slope_std-------------------------------------------;';
    l7 = 'm [-]                                             ;';
    l8 = 'cp [-]                                            ;';
    l9 = 'S [L/T^0.5]                                      ;';
    l10 = 'α_WR [T^-1]----------------------------------------;';
    l11 = 'Chosen data points for PSD Analysis:              ;';
    l12 = 'Chosen data points for Cumulative Infiltration:   ;';
    l13 = 'Initialization ?                                  ;';
    l14 = 'Chosen data points for Steady method:             ;';

    lr00a = file_name;
    lr00b = 'BEST-WR-3T';
    lr00c = 'Minasny';
    lr00d = '------';
    lr0 = string(thetar);
    lr1 = string(thetas);
    lr2 = string(hg_opt);
    lr3 = string(Ks_opt);
    lr4 = string(n);
    lr5 = string(eta);
    lr6 = string(qexpinf);
    lr7 = string(m);
    lr8 = string(cp);
    lr9 = string(S_opt);
    lr10 = string(aWR);
    lr11 = 'ps and pc';
    lr12 = string(n_data_1)+':'+string(n_data_2)+' out of '+string(size(X2,1));
    if Initialize == 1 then lr13 = 'yes';
        else lr13 = 'no';
    end
//    lr14 = string(n_cl_1)+':'+string(n_cl_2)+' out of '+string(size(t_sci_2,1));
    lr14 = string(n1_end)+':'+string(n2_end)+' out of '+string(size(t_sci,1));
//    lr15 = +string(n_end);

    
    txt_result_1 = 'BEST Hydraulic parameters';

    txt_result_2_ = [l00a;l00b;l00c;l00d;l0;l1;l2;l3;l4;l5;l6;l7;l8;l9;l10;l11;l12;l13;l14];
    txt_result_3 = [lr00a;lr00b;lr00c;lr00d;lr0;lr1;lr2;lr3;lr4;lr5;lr6;lr7;lr8;lr9;lr10;lr11;lr12;lr13;lr14];
    
    for i = 1:size(txt_result_2_,1)
        txt_result_2(i) = part(txt_result_2_(i),1:(length(txt_result_2_(i))-1));
    end

    x_mdialog(txt_result_1,txt_result_2,txt_result_3);

//     pause

// --- SAVINGS ----------------------------------------------------

      
    Result = txt_result_2_+txt_result_3;
    HCWRF = [h_ theta_vGB_ K_vGBBC_];
   
    T4 = T1+'\Result';

    T4 = uigetdir(T4,'Go to Result directory');
    chdir(T4);
    
    if T4 == '' then
        chdir(T1);
        x_mdialog('BEST program is ended','Caution: remove files from \Result and \Figures folders','Press ok');
        abort;
    end
    
     txt_saving = ['Save Result data?';'Save HCWRF data?';'Save figures?';'File name for results?';'File name for HCWRF?'];
     txt_saving_2 = ['no';'no';'no';'BEST-Steady-MM_Results_'+file_name;'BEST-Steady-MM_HCWRF_'+file_name];
     sig_saving = x_mdialog('Savings',txt_saving,txt_saving_2);
     
     if sig_saving ==[] then
        chdir(T1);
        x_mdialog('BEST program is ended','Caution: remove files from \Result and \Figures folders','Press ok');
        abort;
     end
     
     Save_result = sig_saving(1);
     Save_HCWRF = sig_saving(2);
     Save_Fig = sig_saving(3);
     Result_name = sig_saving(4);
     HCWRF_name = sig_saving(5);

    if Save_result == 'yes' then
//        erase_file(Result_name+'.txt');
        write(Result_name+'.txt',Result);
    end;

    if Save_HCWRF == 'yes' then
//        erase_file(HCWRF_name+'.txt');c 
        write(HCWRF_name+'.txt',HCWRF);
    end;
    
    chdir(T4+'\Figures');
    
    if Save_Fig == 'yes' then
        for i = 1:i_fig
            xs2bmp(i,'BEST-Steady-MM_'+file_name+'_fig'+string(i));
        end
    end;
    
    chdir(T2);
    
    
    
    
   
   

